/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * This file is part of CMUcamGUI, a java program that helps     *
 * interface with the CMUcam Vision Board.                       *
 * Contact cmucam@cs.cmu.edu, or see                             *
 * http://www.cs.cmu.edu/~cmucam for more information.           *
 *                                                               *
 * Copyright 2001 Anthony Rowe                                   *
 *                                                               *
 * This program is free software; you can redistribute it and/or *
 * modify it under the terms of the GNU General Public License   *
 * as published by the Free Software Foundation - version 2.     *
 *                                                               *
 * This program is distributed in the hope that it will be       *
 * useful, but WITHOUT ANY WARRANTY; without even the implied    *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR       *
 * PURPOSE.  See the GNU General Public License in file COPYING  *
 * for more details.                                             *
 *                                                               *
 * You should have received a copy of the GNU General Public     *
 * License along with this program; if not, write to the Free    *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,       *
 * Boston, MA 02111, USA.                                        *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.io.*;
import java.lang.Object;
import java.util.*;

/*
This function handles the window that sets the tracking
parameters and then creates the tracking string to send
to the camera.
*/

public class colorTrack extends Canvas
{
Frame tracker_f;
Panel tracker_p;
TextField rMin,rMax,gMin,gMax,bMin,bMax;


    colorTrack()
    {
	tracker_f= new Frame("Color Tracker");
	Panel tracker_p = new Panel();
	tracker_f.setBackground(Color.lightGray);
	tracker_f.setLayout(new GridLayout(3,3));
	rMin=new TextField("0");
	rMax=new TextField("0");
	gMin=new TextField("0");
	gMax=new TextField("0");
	bMin=new TextField("0");
	bMax=new TextField("0");
	tracker_f.add(new Label("Red (min max)"));
	tracker_f.add(rMin);
	tracker_f.add(rMax);
	tracker_f.add(new Label("Green (min max)"));
	tracker_f.add(gMin);
	tracker_f.add(gMax);
	tracker_f.add(new Label("Blue (min max)"));
	tracker_f.add(bMin);
	tracker_f.add(bMax);
	tracker_f.setSize(300,120);
	tracker_f.setLocation(260,100);
	tracker_f.show();
    }
    public void hide() { tracker_f.hide(); }
    public void show() { tracker_f.show(); }

    public String sendString()
    {
	return("TC " +rMin.getText()+" "+rMax.getText()+" "+gMin.getText()
	         + " " +gMax.getText()+" "+bMin.getText()+" "+bMax.getText()
	       + "\r" );


    }

}
