/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * This file is part of CMUcamGUI, a java program that helps     *
 * interface with the CMUcam Vision Board.                       *
 * Contact cmucam@cs.cmu.edu, or see                             *
 * http://www.cs.cmu.edu/~cmucam for more information.           *
 *                                                               *
 * Copyright 2001 Anthony Rowe                                   *
 *                                                               *
 * This program is free software; you can redistribute it and/or *
 * modify it under the terms of the GNU General Public License   *
 * as published by the Free Software Foundation - version 2.     *
 *                                                               *
 * This program is distributed in the hope that it will be       *
 * useful, but WITHOUT ANY WARRANTY; without even the implied    *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR       *
 * PURPOSE.  See the GNU General Public License in file COPYING  *
 * for more details.                                             *
 *                                                               *
 * You should have received a copy of the GNU General Public     *
 * License along with this program; if not, write to the Free    *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,       *
 * Boston, MA 02111, USA.                                        *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.io.*;
import java.lang.Object;
import java.util.*;


public class meanWindow extends Canvas
{
Frame mean_f;
Panel mean_p,cmin,cmean,cmax;
TextField rMean,rDev,gMean,gDev,bMean,bDev;


    meanWindow()
    {
	mean_f= new Frame("Mean Color Data");
	Panel tracker_p = new Panel();
	mean_f.setBackground(Color.lightGray);
	mean_f.setLayout(new GridLayout(6,3));
	mean_f.add(new Label(" "));
	mean_f.add(new Label("Mean"));
       	mean_f.add(new Label("Deviation"));
	mean_f.add(new Label("Red"));
	rMean=new TextField("?");
	rDev=new TextField("?");
	cmin=new Panel();
	mean_f.add(rMean);
	mean_f.add(rDev);	

	mean_f.add(new Label("Green"));
	gMean=new TextField("?");
	gDev=new TextField("?");
	cmean=new Panel();	
	mean_f.add(gMean);
	mean_f.add(gDev);	
	
	mean_f.add(new Label("Blue"));
	bMean=new TextField("?");
	bDev=new TextField("?");
	cmax=new Panel();
	mean_f.add(bMean);
	mean_f.add(bDev);
	mean_f.add(new Label("low"));
	mean_f.add(new Label("mean"));
	mean_f.add(new Label("high"));
	mean_f.add(cmin);	
	mean_f.add(cmean);
	mean_f.add(cmax);

	mean_f.setSize(250,200);
	mean_f.setLocation(0,270);
	mean_f.show();
    }
    public void hide() { mean_f.hide(); }
    public void show() { mean_f.show(); }

    public void update(int rm,int gm,int bm,int rd,int gd,int bd)
    {
	int r,g,b;
	rMean.setText((new Integer(rm)).toString());
	gMean.setText((new Integer(gm)).toString());
	bMean.setText((new Integer(bm)).toString());
	rDev.setText((new Integer(rd)).toString());
	gDev.setText((new Integer(gd)).toString());
	bDev.setText((new Integer(bd)).toString());
      
	r=rm-rd;
	g=gm-gd;
	b=bm-bd;
	if(r>254) r=254; if(r<0)r=0;
	if(g>254) g=254; if(g<0)g=0;
	if(b>254) b=254; if(b<0)r=0;
	cmin.setBackground(new Color(r,g,b));
	cmean.setBackground(new Color(rm,gm,bm));
	r=rm+rd;
	g=gm+gd;
	b=bm+bd;	
	if(r>254) r=254; if(r<0)r=0;
	if(g>254) g=254; if(g<0)g=0;
	if(b>254) b=254; if(b<0)r=0;
	cmax.setBackground(new Color(r,g,b));
    }

}
