/*
 * Decompiled with CFR 0.152.
 */
import java.util.Date;

public class CameraSerial {
    public int mx = 5;
    public int my = 3;
    public int x1;
    public int x2;
    public int y1;
    public int y2;
    public int pix;
    public int conf;
    public int fps;
    public int cnt;
    public int rmean;
    public int gmean;
    public int bmean;
    public int rdev;
    public int gdev;
    public int bdev;
    public int[] histogram = new int[29];
    public int[] lineArray = new int[6000];
    public int lnCount;
    public int lmWidth;
    public int lmHeight;
    long startTime;
    int block = 0;
    static SerialComm sPort;

    CameraSerial(String string) {
        int n;
        Date date = new Date();
        this.startTime = date.getTime();
        this.fps = 0;
        sPort = new SerialComm(string);
        MainWindow.status_t.setText("Looking for Camera...");
        sPort.writeStr("\r");
        try {
            Thread.sleep(100L);
        }
        catch (Exception exception) {
            // empty catch block
        }
        char c = '\u0001';
        while (c != '\u0000') {
            c = sPort.readByte();
        }
        for (n = 0; n < 3; ++n) {
            sPort.writeStr("rs\r");
            c = sPort.readByte();
            while (c != 'm') {
                c = sPort.readByte();
            }
            c = sPort.readByte();
            if (c == ' ') {
                MainWindow.cameraVersion = 1;
                MainWindow.cameraType = 6;
                break;
            }
            if (c == '2') {
                MainWindow.cameraVersion = 2;
                break;
            }
            MainWindow.cameraVersion = -1;
        }
        c = '\u0000';
        if (MainWindow.cameraVersion == 2) {
            while (c != 'c') {
                c = sPort.readByte();
            }
            c = sPort.readByte();
            MainWindow.cameraType = c == '6' ? 6 : (c == '7' ? 7 : -1);
            if (MainWindow.cameraVersion == -1) {
                MainWindow.status_t.setText("Unknown Camera Version.");
                return;
            }
            if (MainWindow.cameraType == -1) {
                MainWindow.status_t.setText("Unknown CMOS sensor Type.");
                return;
            }
        }
        for (n = 0; n < 3; ++n) {
            if (this.readACK(1) == 1) {
                MainWindow.status_t.setText("CMUcam Version " + MainWindow.cameraVersion + " type " + MainWindow.cameraType + " ready.");
                break;
            }
            MainWindow.status_t.setText("Camera not found.");
        }
    }

    public char getByte() {
        char c = sPort.readByte();
        return c;
    }

    public void write(String string) {
        sPort.writeStr(string);
    }

    public int readACK(int n) {
        int n2 = 1;
        while (this.block == 1) {
        }
        this.block = 1;
        int n3 = 0;
        sPort.writeStr("\r");
        char c = sPort.readByte();
        while (true) {
            boolean bl = false;
            if (n3 == 4 && c == ':') {
                this.block = 0;
                return n2;
            }
            if (n3 == 3 && c == '\r') {
                n3 = 4;
                bl = true;
            }
            if (n3 == 2 && c == 'K') {
                n3 = 3;
                bl = true;
            }
            if (n3 == 1 && c == 'C') {
                n3 = 2;
                bl = true;
            }
            if (c == 'A') {
                n3 = 1;
                bl = true;
            }
            if ((c = sPort.readByte()) == '\u0000') {
                while (c == '\u0000') {
                    if (n == 1) {
                        n2 = 0;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    sPort.writeStr("\r");
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    for (int i = 0; i < 1000 && (c = sPort.readByte()) == '\u0000'; ++i) {
                    }
                }
            }
            if (bl) continue;
            n3 = 0;
        }
    }

    public int readSpacket() {
        int n = 0;
        while (n != 83) {
            n = sPort.readByte();
            if (n == 254) {
                n = sPort.readByte();
                this.lnCount = 0;
                do {
                    this.lineArray[this.lnCount] = n;
                    ++this.lnCount;
                } while ((n = (int)sPort.readByte()) != 253);
                System.out.print("Line Count: " + this.lnCount + " ");
                n = sPort.readByte();
                if (n == 0) {
                    MainWindow.status_t.setText("S packet failed");
                    return 0;
                }
            }
            if (n != 0) continue;
            MainWindow.status_t.setText("S packet failed");
            return 0;
        }
        n = sPort.readByte();
        if (n == 0) {
            return 0;
        }
        this.rmean = sPort.readNum();
        if (this.rmean == -1) {
            return 0;
        }
        this.gmean = sPort.readNum();
        if (this.gmean == -1) {
            return 0;
        }
        this.bmean = sPort.readNum();
        if (this.bmean == -1) {
            return 0;
        }
        this.rdev = sPort.readNum();
        if (this.rdev == -1) {
            return 0;
        }
        this.gdev = sPort.readNum();
        if (this.gdev == -1) {
            return 0;
        }
        this.bdev = sPort.readNum();
        if (this.bdev == -1) {
            return 0;
        }
        this.updateFPS();
        MainWindow.sFPS_l.setText(new Integer(this.fps).toString());
        System.out.print("FPS: " + this.fps + " S: " + this.rmean + " " + this.gmean + " " + this.bmean + " " + this.rdev + " " + this.gdev + " " + this.bdev + "\n");
        return 1;
    }

    public int readHpacket() {
        int n;
        if (MainWindow.cameraVersion == 1) {
            MainWindow.status_t.setText("Not Supported on CMUcam 1");
            return 0;
        }
        int n2 = 0;
        while (n2 != 72) {
            n2 = sPort.readByte();
            if (n2 != 0) continue;
            MainWindow.status_t.setText("H packet failed");
            return 0;
        }
        n2 = sPort.readByte();
        for (n = 0; n < 28; ++n) {
            this.histogram[n] = sPort.readNum();
        }
        this.updateFPS();
        MainWindow.hFPS_l.setText(new Integer(this.fps).toString());
        System.out.print("FPS: " + this.fps + " H: ");
        for (n = 0; n < 28; ++n) {
            System.out.print(this.histogram[n] + " ");
        }
        System.out.println("");
        return 1;
    }

    public int readTpacket() {
        boolean bl = false;
        int n = 0;
        this.lnCount = 0;
        int n2 = 84;
        if (MainWindow.cameraVersion == 1) {
            n2 = 77;
        }
        while (n != n2) {
            n = sPort.readByte();
            int n3 = 0;
            if (n == 170 || n == 252 || n == 254) {
                boolean bl2 = false;
                n3 = n;
                if (MainWindow.cameraVersion != 1) {
                    this.lmWidth = sPort.readByte();
                    if (MainWindow.track_color_linemode != 2) {
                        this.lmHeight = sPort.readByte();
                    }
                } else {
                    this.lmWidth = 10;
                    this.lmHeight = 72;
                }
                n = sPort.readByte();
                do {
                    this.lineArray[this.lnCount] = n;
                    ++this.lnCount;
                    if (this.lnCount <= 5999) continue;
                    this.lnCount = 5999;
                } while (!((n = (int)sPort.readByte()) == 170 && n3 == 170 || n == 253 && n3 == 252) && (n != 253 || n3 != 254));
                n = sPort.readByte();
                if (this.lmWidth == 0) {
                    this.lmWidth = 1;
                }
                System.out.print("Line mode: " + this.lmWidth + "," + this.lmHeight + " ");
            }
            if (n != 0) continue;
            MainWindow.status_t.setText("Track packet failed");
            return 0;
        }
        n = sPort.readByte();
        if (n == 0) {
            return 0;
        }
        this.mx = sPort.readNum();
        if (this.mx == -1) {
            return 0;
        }
        this.my = sPort.readNum();
        if (this.my == -1) {
            return 0;
        }
        this.x1 = sPort.readNum();
        if (this.x1 == -1) {
            return 0;
        }
        this.y1 = sPort.readNum();
        if (this.y1 == -1) {
            return 0;
        }
        this.x2 = sPort.readNum();
        if (this.x2 == -1) {
            return 0;
        }
        this.y2 = sPort.readNum();
        if (this.y2 == -1) {
            return 0;
        }
        this.pix = sPort.readNum();
        if (this.pix == -1) {
            return 0;
        }
        this.conf = sPort.readNum();
        if (this.conf == -1) {
            return 0;
        }
        this.updateFPS();
        MainWindow.cFPS_l.setText(new Integer(this.fps).toString());
        MainWindow.mFPS_l.setText(new Integer(this.fps).toString());
        System.out.println("FPS: " + this.fps + " T: " + this.mx + " " + this.my + " " + this.x1 + " " + this.y1 + " " + this.x2 + " " + this.y2 + " " + this.pix + " " + this.conf);
        return 1;
    }

    private void updateFPS() {
        ++this.cnt;
        Date date = new Date();
        if (date.getTime() - this.startTime > 1000L) {
            this.fps = this.cnt;
            this.startTime = date.getTime();
            this.cnt = 0;
        }
    }
}

