/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import javax.swing.JPanel;

public class ColorTrack
extends JPanel {
    int active = 0;
    int mx_g;
    int my_g;
    int x1_g;
    int y1_g;
    int x2_g;
    int y2_g;
    int pix_g;
    int conf_g;
    MemoryImageSource source;
    Image image;
    int width;
    int height;
    int[] pixels;

    ColorTrack() {
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.pixels = new int[this.width * this.height];
        this.source = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
        this.source.setAnimated(true);
        this.image = this.createImage(this.source);
    }

    public void stop() {
        this.active = 0;
    }

    public void trackColor() {
        this.active = 1;
        if (MainWindow.mySerial.readTpacket() == 0) {
            System.out.println("Aborting Track...");
            MainWindow.commandVal = -1;
            this.active = 0;
            this.repaint();
            return;
        }
        this.mx_g = MainWindow.mySerial.mx;
        this.my_g = MainWindow.mySerial.my;
        this.x1_g = MainWindow.mySerial.x1;
        this.y1_g = MainWindow.mySerial.y1;
        this.x2_g = MainWindow.mySerial.x2;
        this.y2_g = MainWindow.mySerial.y2;
        this.pix_g = MainWindow.mySerial.pix;
        this.conf_g = MainWindow.mySerial.conf;
        this.repaint();
    }

    public void paintComponent(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = (n - 320) / 2;
        int n4 = (n2 - 320) / 2;
        graphics.setColor(Color.darkGray);
        graphics.fillRect(0, 0, n + 1, n2 + 1);
        graphics.setColor(Color.green);
        graphics.drawRect(n3, n4, 320, 320);
        if (this.active == 1) {
            int n5;
            int n6;
            int n7;
            int n8;
            double d;
            double d2;
            if (MainWindow.hr_c.getSelectedIndex() == 0 && MainWindow.cameraType == 6) {
                d2 = 3.63;
                d = 2.22;
            } else {
                d2 = 1.82;
                d = 1.27;
            }
            if (MainWindow.cameraVersion == 1) {
                d2 = 3.63;
                d = 2.22;
            }
            if (this.mx_g == 0 && this.my_g == 0) {
                return;
            }
            ++this.x2_g;
            ++this.y2_g;
            graphics.setColor(Color.blue);
            graphics.fillRect((int)((double)this.x1_g * d2 + (double)n3), (int)((double)this.y1_g * d) + n4, (int)((double)(this.x2_g - this.x1_g) * d2), (int)((double)(this.y2_g - this.y1_g) * d));
            graphics.setColor(Color.cyan);
            int n9 = new Integer(MainWindow.x1.getText());
            int n10 = new Integer(MainWindow.y1.getText());
            if (--n9 < 0 || n9 > 255) {
                n9 = 0;
            }
            if (n10 < 0 || n10 > 255) {
                n10 = 0;
            }
            if (MainWindow.track_color_linemode == 1) {
                int n11 = MainWindow.mySerial.lmHeight;
                int n12 = MainWindow.mySerial.lmWidth;
                n12 = (n12 + 7) / 8;
                if (MainWindow.cameraVersion != 1) {
                    for (n8 = 0; n8 < n11; ++n8) {
                        for (n7 = 0; n7 < n12; ++n7) {
                            for (n6 = 0; n6 < 8; ++n6) {
                                if (n8 * n12 + n7 > 5999) {
                                    return;
                                }
                                n5 = MainWindow.mySerial.lineArray[n8 * n12 + n7] >> n6;
                                if ((n5 &= 1) != 1) continue;
                                graphics.setColor(Color.cyan);
                                graphics.fillRect(n3 + (int)((double)(n7 * 8 + (8 - n6) + n9) * d2), n4 + (int)((double)(n8 + n10) * d), (int)(d2 + 1.0), (int)(d + 1.0));
                            }
                        }
                    }
                } else {
                    n11 /= 2;
                    for (n8 = 0; n8 < n11; ++n8) {
                        for (n7 = 0; n7 < n12; ++n7) {
                            for (n6 = 0; n6 < 8; ++n6) {
                                if (n8 * n12 + n7 > 5999) {
                                    return;
                                }
                                n5 = MainWindow.mySerial.lineArray[(n11 - n8) * n12 + n7] >> n6;
                                if ((n5 &= 1) != 1) continue;
                                graphics.setColor(Color.cyan);
                                graphics.fillRect(n3 + (int)((double)(n7 * 8 + (8 - n6) + n9) * d2), n4 + (int)((double)(n8 + n10) * (4.0 * d)), (int)(d2 + 1.0), (int)(2.0 * d + 1.0));
                            }
                        }
                    }
                }
            }
            if (MainWindow.track_color_linemode == 2) {
                n8 = MainWindow.mySerial.lmWidth;
                for (n7 = 0; n7 < n8; ++n7) {
                    n5 = MainWindow.mySerial.lineArray[n7 * 5];
                    n6 = MainWindow.mySerial.lineArray[n7 * 5 + 1];
                    int n13 = MainWindow.mySerial.lineArray[n7 * 5 + 2];
                    int n14 = MainWindow.mySerial.lineArray[n7 * 5 + 3];
                    int n15 = MainWindow.mySerial.lineArray[n7 * 5 + 4];
                    if (n5 == 0) continue;
                    graphics.setColor(Color.yellow);
                    graphics.fillRect(n3 + (int)(d2 * (double)n6), n4 + (int)((double)n7 * d) + (int)((double)n10 * d), (int)((double)(n13 - n6) * d2 + 1.0), (int)(d + 1.0));
                    graphics.setColor(Color.magenta);
                    graphics.fillRect(n3 + (int)(d2 * (double)n5), n4 + (int)((double)n7 * d) + (int)((double)n10 * d), (int)(d2 + 1.0), (int)(d + 1.0));
                }
            }
            graphics.setColor(Color.red);
            graphics.fillRect((int)((double)this.mx_g * d2 + (double)n3), (int)((double)this.my_g * d + (double)n4), 4, 4);
        }
    }
}

