/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import javax.swing.JPanel;

public class Histogram
extends JPanel {
    int active = 0;
    int mx_g;
    int my_g;
    int x1_g;
    int y1_g;
    int x2_g;
    int y2_g;
    int pix_g;
    int conf_g;
    MemoryImageSource source;
    Image image;
    int width;
    int height;
    int[] pixels;

    Histogram() {
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.width = this.getSize().width;
        this.height = this.getSize().height;
        this.pixels = new int[this.width * this.height];
        this.source = new MemoryImageSource(this.width, this.height, this.pixels, 0, this.width);
        this.source.setAnimated(true);
        this.image = this.createImage(this.source);
    }

    public void getHistogram() {
        this.active = 1;
        if (MainWindow.mySerial.readHpacket() == 0) {
            System.out.println("Aborting H packet read...");
            MainWindow.commandVal = -1;
            this.active = 0;
            this.repaint();
            return;
        }
        this.repaint();
    }

    public void stop() {
        this.active = 0;
    }

    public void paintComponent(Graphics graphics) {
        int n = this.getSize().width;
        int n2 = this.getSize().height;
        int n3 = (n - 320) / 2;
        int n4 = (n2 - 320) / 2;
        graphics.setColor(Color.darkGray);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(Color.green);
        graphics.drawRect(n3, n4, 320, 320);
        if (this.active == 1) {
            if (MainWindow.channel_c.getSelectedIndex() == 0) {
                graphics.setColor(Color.red);
            } else if (MainWindow.channel_c.getSelectedIndex() == 1) {
                graphics.setColor(Color.green);
            } else {
                graphics.setColor(Color.blue);
            }
            for (int i = 0; i < 28; ++i) {
                int n5 = MainWindow.mySerial.histogram[i];
                if (n5 > 160) {
                    n5 = 160;
                }
                graphics.fillRect(i * 10 + n3 + 15, n4 + 2 * (160 - n5), 10, 320 - 2 * (160 - n5));
            }
        }
    }
}

