/*
 * Decompiled with CFR 0.152.
 */
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Date;

public class SerialComm {
    FileOutputStream sPortOut;
    FileInputStream sPortIn;
    int os;

    SerialComm(String string) {
        String string2 = new String(System.getProperty("os.name"));
        this.os = string2.startsWith("Windows") ? 0 : 1;
        if (this.os == 0) {
            System.out.println("Windows Detected");
            int n = serialPort.openSerial(new Integer(string), 5);
            if (n != 0) {
                System.err.println("Error " + n + " during openSerial()");
                System.exit(0);
            }
            serialPort.setReadTimeout(50);
            System.out.println("serial port successfully opened!");
        } else {
            System.out.println("Unix Based System Detected");
            try {
                this.sPortIn = new FileInputStream(string);
                this.sPortOut = new FileOutputStream(string);
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }

    public int readNum() {
        char c = this.readByte();
        if (c == '\u0000') {
            return -1;
        }
        char c2 = this.readByte();
        if (c2 == '\u0000') {
            return -1;
        }
        if (c2 == ' ' || c2 == '\r') {
            return c - 48;
        }
        char c3 = this.readByte();
        if (c3 == '\u0000') {
            return -1;
        }
        if (c3 == ' ' || c3 == '\r') {
            return (c - 48) * 10 + (c2 - 48);
        }
        char c4 = this.readByte();
        if (c4 == '\u0000') {
            return -1;
        }
        return (c - 48) * 100 + (c2 - 48) * 10 + (c3 - 48);
    }

    public char readByte() {
        Date date = new Date();
        long l = date.getTime();
        if (this.os == 0) {
            int n = -1;
            while (n == -1) {
                n = serialPort.readByte();
                Date date2 = new Date();
                if (date2.getTime() - l <= 1000L) continue;
                System.out.println("Waiting for Serial data...");
                return '\u0000';
            }
            return (char)n;
        }
        try {
            while (this.sPortIn.available() == 0) {
                Date date3 = new Date();
                if (date3.getTime() - l <= 100L) continue;
                System.out.println("Waiting for Serial data...");
                return '\u0000';
            }
            return (char)this.sPortIn.read();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return '\u0000';
        }
    }

    public char readNonBlock() {
        if (this.os == 0) {
            int n = serialPort.readByte();
            if (n == -1) {
                n = 0;
            }
            return (char)n;
        }
        try {
            if (this.sPortIn.available() == 0) {
                return '\u0000';
            }
            return (char)this.sPortIn.read();
        }
        catch (Exception exception) {
            System.out.println(exception);
            return '\u0000';
        }
    }

    public void writeStr(String string) {
        if (this.os == 0) {
            byte[] byArray = string.getBytes();
            for (int i = 0; i < byArray.length; ++i) {
                int n = serialPort.sendByte(byArray[i]);
                if (n == 0) continue;
                System.out.println("Serial Send error");
                break;
            }
        } else {
            try {
                this.sPortOut.write(string.getBytes());
            }
            catch (Exception exception) {
                System.out.println(exception);
            }
        }
    }
}

