/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * This file is part of CMUcamGUI, a java program that helps     *
 * interface with the CMUcam Vision Board.                       *
 * Contact cmucam@cs.cmu.edu, or see                             *
 * http://www.cs.cmu.edu/~cmucam for more information.           *
 *                                                               *
 * Copyright 2001 Anthony Rowe                                   *
 *                                                               *
 * This program is free software; you can redistribute it and/or *
 * modify it under the terms of the GNU General Public License   *
 * as published by the Free Software Foundation - version 2.     *
 *                                                               *
 * This program is distributed in the hope that it will be       *
 * useful, but WITHOUT ANY WARRANTY; without even the implied    *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR       *
 * PURPOSE.  See the GNU General Public License in file COPYING  *
 * for more details.                                             *
 *                                                               *
 * You should have received a copy of the GNU General Public     *
 * License along with this program; if not, write to the Free    *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,       *
 * Boston, MA 02111, USA.                                        *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.io.*;
import java.lang.Object;
import java.util.*;

/* 
This class handles the camera settings window.  It uses the values
set by the popup menu to create the correct camera setting string.
*/
public class camSettings extends Canvas
{
    Frame camSettings_f;
    Panel camSettings_p;
    Choice fps_c,cam_c,gain_c;

    camSettings()
    {
	camSettings_f= new Frame("Camera Registers");
	Panel camSettings_p = new Panel();
	camSettings_f.setBackground(Color.lightGray);
	camSettings_f.setLayout(new GridLayout(3,2));
	camSettings_f.add(new Label("Clock (fps)"));
	fps_c = new Choice();
	fps_c.addItem("17");
	fps_c.addItem("13");
	fps_c.addItem("11");
	fps_c.addItem("9");
	fps_c.addItem("8");
	fps_c.addItem("7");
	fps_c.addItem("6");
	fps_c.addItem("5");
	fps_c.addItem("4");
	camSettings_f.add(fps_c);
	camSettings_f.add(new Label("Image Modes"));
	cam_c = new Choice();
	cam_c.addItem("RGB WB Off");
	cam_c.addItem("RGB WB On");
	cam_c.addItem("YUV WB Off");
	cam_c.addItem("YUV WB On");
	camSettings_f.add(cam_c);	
	camSettings_f.add(new Label("Auto Gain"));
	gain_c = new Choice();
	gain_c.addItem("On");
	gain_c.addItem("Off");
	camSettings_f.add(gain_c);
	camSettings_f.setSize(250,100);
	camSettings_f.setLocation(0,480);
	camSettings_f.show();
	
    }
    public void hide() { camSettings_f.hide(); }
    public void show() { camSettings_f.show(); }

    public String getString()
    {
	int color_mode=44;
	int fps=2;
	int gain=33;

	switch(cam_c.getSelectedIndex())
	    {
	    case 0: color_mode=40; break;
	    case 1: color_mode=44; break;
	    case 2: color_mode=32; break;
	    case 3: color_mode=36; break;	
	    }
	switch(fps_c.getSelectedIndex())
	    {
	    case 0: fps=2; break;
	    case 1: fps=3; break;
	    case 3: fps=4; break;
	    case 4: fps=5; break;
	    case 5: fps=6; break;
	    case 6: fps=7; break;
	    case 7: fps=8; break;
	    case 8: fps=9; break;
	    case 9: fps=10; break;
	    case 10: fps=11; break;
	    case 11: fps=12; break;
	    }
	switch(gain_c.getSelectedIndex())
	    {
	    case 0: gain=33; break;
	    case 1: gain=32; break;
	    }
	return( "CR 18 " + new Integer(color_mode).toString()
	       + " 17 " + new Integer(fps).toString()
	       + " 19 " + new Integer(gain).toString());
    }
    

}
