/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *\
 * This file is part of CMUcamGUI, a java program that helps     *
 * interface with the CMUcam Vision Board.                       *
 * Contact cmucam@cs.cmu.edu, or see                             *
 * http://www.cs.cmu.edu/~cmucam for more information.           *
 *                                                               *
 * Copyright 2001 Anthony Rowe                                   *
 *                                                               *
 * This program is free software; you can redistribute it and/or *
 * modify it under the terms of the GNU General Public License   *
 * as published by the Free Software Foundation - version 2.     *
 *                                                               *
 * This program is distributed in the hope that it will be       *
 * useful, but WITHOUT ANY WARRANTY; without even the implied    *
 * warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR       *
 * PURPOSE.  See the GNU General Public License in file COPYING  *
 * for more details.                                             *
 *                                                               *
 * You should have received a copy of the GNU General Public     *
 * License along with this program; if not, write to the Free    *
 * Software Foundation, Inc., 59 Temple Place - Suite 330,       *
 * Boston, MA 02111, USA.                                        *
\* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */
import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.io.*;
import java.lang.Object;
import java.util.*;

/*
This class handles the channels window.  It takes care
of grabbing the data from the main screen and drawing
it broken apart on the channels window.
*/ 
public class channelWindow extends Canvas
{
  
    int w,h;
    int chan1[];
    int update;

    channelWindow(int width,int height)
    {
	w=width;
	h=height;
	chan1=new int[width*height];
	update=0;
    }
    
    public void splitChannels(int pixels[])
    {
	chan1=pixels;
	update=1;
	repaint();
    }

    public void update(Graphics g)
    {	

	paint(g);

    }

    /*
       This is where most of the work is done.
       The image gets read and drawn directly to
       the screen.
    */
    public void paint(Graphics g)
    {
	int mainPix,x,y,ch1,ch2,ch3,tmp;

	if(update==1)
	for(x=0; x<w; x++ )
	    for(y=0; y<h; y++ )
		{
		    mainPix=chan1[y*w+x];
		    tmp=mainPix & 0xFF0000;
		    tmp=tmp>>16;
		    ch3=tmp+(tmp<<8)+(tmp<<16);
		    Color pixColor3= new Color(ch3);	
		    g.setColor(pixColor3);
		    g.fillRect(x+10,y+10,1,1); 
		   
		    
		    tmp=mainPix & 0xFF00;
		    tmp=tmp>>8;
		    ch2=tmp+(tmp<<8)+(tmp<<16);
		    Color pixColor2= new Color(ch2);	
		    g.setColor(pixColor2);
		    g.fillRect(x+10,y+h+20,1,1);
		    
		    tmp=mainPix & 0xFF;
		    ch1=tmp+(tmp<<8)+(tmp<<16);
		    Color pixColor= new Color(ch1);	
		    g.setColor(pixColor);
		    g.fillRect(x+10,y+(2*h)+30,1,1);
		   
		}
	update=0;





    }


}
